local Portrait = {}
ShadowUF:RegisterModule(Portrait, "portrait", ShadowUF.L["Portrait"])

-- If the camera isn't reset OnShow, it'll show the entire character instead of just the head, odd I know
local function resetCamera(self)
	self:SetPortraitZoom(1)
end

local function resetGUID(self)
	self.guid = nil
	self._nextSecretUpdate = nil
end

function Portrait:OnEnable(frame)
	frame:RegisterUnitEvent("UNIT_PORTRAIT_UPDATE", self, "UpdateFunc")
	frame:RegisterUnitEvent("UNIT_MODEL_CHANGED", self, "Update")

	frame:RegisterUpdateFunc(self, "UpdateFunc")
end

function Portrait:OnDisable(frame)
	frame:UnregisterAll(self)
end

function Portrait:OnPreLayoutApply(frame, config)
	if( not frame.visibility.portrait ) then return end

	if( config.portrait.type == "3D" ) then
		if( not frame.portraitModel ) then
			frame.portraitModel = CreateFrame("PlayerModel", nil, frame)
			frame.portraitModel:SetScript("OnShow", resetCamera)
			frame.portraitModel:SetScript("OnHide", resetGUID)
			frame.portraitModel.parent = frame
		end

		frame.portrait = frame.portraitModel
		frame.portrait:Show()

		ShadowUF.Layout:ToggleVisibility(frame.portraitTexture, false)
	else
		frame.portraitTexture = frame.portraitTexture or frame:CreateTexture(nil, "ARTWORK")
		frame.portrait = frame.portraitTexture
		frame.portrait:Show()

		ShadowUF.Layout:ToggleVisibility(frame.portraitModel, false)
	end
end

function Portrait:UpdateFunc(frame)
	-- Portrait models can't be updated unless the GUID changed or else you have the animation jumping around
	if( ShadowUF.db.profile.units[frame.unitType].portrait.type == "3D" ) then
		local guid = UnitGUID(frame.unitOwner)
		local prev = frame.portrait.guid

		-- Only compare when it is safe (not secret + caller can access the value).
		local canCompare = false
		
		-- Use Blizzard globals for secret checks if available
		if (_G.canaccessvalue and _G.issecretvalue) then
			canCompare = guid ~= nil and prev ~= nil and 
						canaccessvalue(guid) and canaccessvalue(prev) and 
						(not issecretvalue(guid)) and (not issecretvalue(prev))
		else
			-- Fallback: basic type check (if globals missing)
			canCompare = type(guid) == "string" and type(prev) == "string"
		end

		if canCompare then
			if prev ~= guid then
				self:Update(frame)
			end
		else
			-- If we cannot compare (secret/tainted), do a throttled update so we do not jitter every frame (credits Xinux_vg).
			local now = GetTime()
			if not frame.portrait._nextSecretUpdate or now >= frame.portrait._nextSecretUpdate then
				self:Update(frame)
				frame.portrait._nextSecretUpdate = now + 0.50
			end
		end

		-- Storing secrets is allowed; we just do not compare them unless safe.
		frame.portrait.guid = guid
	else
		self:Update(frame)
	end
end

function Portrait:Update(frame, event)
	local type = ShadowUF.db.profile.units[frame.unitType].portrait.type
	-- Use class thingy
	if( type == "class" ) then
		local classToken = frame:UnitClassToken()
		if( classToken ) then
			local classIconAtlas = GetClassAtlas(classToken)
			if( classIconAtlas ) then
				frame.portrait:SetAtlas(classIconAtlas)
			else
				frame.portrait:SetTexture("")
			end
		else
			frame.portrait:SetTexture("")
		end
	-- Use 2D character image
	elseif( type == "2D" ) then
		frame.portrait:SetTexCoord(0.10, 0.90, 0.10, 0.90)
		SetPortraitTexture(frame.portrait, frame.unitOwner)
	-- Using 3D portrait, but the players not in range so swap to question mark
	elseif( not UnitIsVisible(frame.unitOwner) or not UnitIsConnected(frame.unitOwner) ) then
		frame.portrait:ClearModel()
		frame.portrait:SetModelScale(5.5)
		frame.portrait:SetPosition(0, 0, -0.8)
		frame.portrait:SetModel("Interface\\Buttons\\talktomequestionmark.m2")

	-- Use animated 3D portrait
	else
		frame.portrait:ClearModel()
		frame.portrait:SetUnit(frame.unitOwner)
		frame.portrait:SetPortraitZoom(1)
		frame.portrait:SetPosition(0, 0, 0)
		frame.portrait:Show()
	end
end




